<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;

class Proyek extends Model
{
    use HasFactory, SoftDeletes;

    protected $primaryKey = 'id_proyek';
    
    protected $fillable = [
        'nama_proyek',
        'klien',
        'nilai_kontrak',
        'tanggal_mulai',
        'target_selesai',
        'status',
        'pic',
        'no_pic',
        'deskripsi',
    ];

    /**
     * Relasi ke Pengeluaran
     */
    public function pengeluarans()
    {
        return $this->hasMany(Pengeluaran::class, 'id_proyek', 'id_proyek');
    }

    /**
     * [BARU DITAMBAHKAN]
     * Relasi ke data pembayaran Tukang.
     * Ini akan memperbaiki error 'Call to undefined method tukangs()'.
     */
    public function tukangs()
    {
        // Pastikan nama model 'Tukang' dan foreign key 'id_proyek' sudah benar
        return $this->hasMany(Tukang::class, 'id_proyek', 'id_proyek');
    }
    public function dataKlien()
    {
        // Relasi ke DataKlien: 
        // 'id_proyek' (di tabel data_kliens) terhubung ke 'id_proyek' (di tabel proyeks)
        return $this->hasOne(DataKlien::class, 'id_proyek', 'id_proyek');
    }

    /**
     * Accessor untuk Sisa Waktu
     */
    public function getSisaWaktuAttribute()
    {
        if ($this->status == 'Selesai') {
            return 'Selesai';
        }
        
        $target = Carbon::parse($this->target_selesai)->startOfDay();
        $now = Carbon::now()->startOfDay();
        
        if ($now->greaterThan($target)) {
            return 'Terlambat ' . $now->diffInDays($target) . ' hari';
        }
        
        $sisa = $now->diffInDays($target);
        return $sisa . ' hari lagi';
    }
}