<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Task extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'title',
        'description',
        'proyek_id',
        'anggota_id', // <-- INI YANG BENAR
        'created_by_user_id',
        'status',
        'priority',
        'due_date',
        'completed_at',
    ];

    protected $casts = [
        'due_date' => 'date',
        'completed_at' => 'datetime',
    ];

    // Relasi: Task ini milik Proyek mana
    public function proyek()
    {
        return $this->belongsTo(Proyek::class, 'proyek_id');
    }

    /**
     * [PERBAIKAN 2] Ini adalah relasi "anggota" yang hilang.
     * Fungsi 'assignee()' yang lama sudah dihapus dan diganti ini.
     */
    public function anggota()
    {
        // Menunjuk ke Model Anggota dan foreign key 'anggota_id'
        return $this->belongsTo(Anggota::class, 'anggota_id');
    }

    // Relasi: Siapa yang membuat task (Creator)
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by_user_id');
    }
}