@extends('layouts.app')

@section('content')
<div x-data="{ showDeleteModal: false, deleteModalAction: '', deleteModalMessage: '', deleteModalTitle: '' }" class="">

    <div class="container mx-auto">
        <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-8 gap-4">
            <div>
                <h2 class="text-3xl font-bold text-gray-800 mb-2">Manajemen Users</h2>
                <p class="text-gray-600">Kelola pengguna dan akses mereka ke sistem</p>
            </div>
            <a href="{{ route('users.create') }}" class="bg-gradient-to-r from-blue-600 to-indigo-700 hover:from-blue-700 hover:to-indigo-800 text-white font-bold py-3 px-6 rounded-full shadow-lg flex items-center gap-2 transition-all duration-300 transform hover:scale-105">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z" clip-rule="evenodd" />
                </svg>
                Tambah User Baru
            </a>
        </div>

        {{-- Pesan Sukses --}}
        @if (session('success'))
            <div class="bg-green-50 border border-green-200 text-green-700 px-6 py-4 rounded-xl mb-6 flex items-center gap-3 shadow-sm animate-fade-in-down" role="alert">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <span class="block sm:inline">{{ session('success') }}</span>
            </div>
        @endif

        <div class="bg-white bg-opacity-90 backdrop-blur-lg rounded-2xl shadow-xl overflow-hidden border border-white border-opacity-30">
            <div class="p-6 border-b border-gray-200">
                <h3 class="text-xl font-semibold text-gray-800">Daftar Pengguna</h3>
                <p class="text-gray-600 text-sm">Semua pengguna terdaftar dalam sistem</p>
            </div>
            
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead class="bg-gray-50 border-b border-gray-200">
                        <tr>
                            <th class="text-left py-4 px-6 font-semibold text-gray-700">#</th>
                            <th class="text-left py-4 px-6 font-semibold text-gray-700">Nama</th>
                            <th class="text-left py-4 px-6 font-semibold text-gray-700">Username</th>
                            <th class="text-left py-4 px-6 font-semibold text-gray-700">Proyek Ditugaskan</th>
                            <th class="text-center py-4 px-6 font-semibold text-gray-700">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="text-gray-700">
                        @forelse ($users as $key => $user)
                            <tr class="border-b border-gray-100 hover:bg-blue-50 transition-all duration-200 hover:scale-[1.01]">
                                <td class="py-4 px-6 font-medium">{{ $loop->iteration }}</td>
                                <td class="py-4 px-6">
                                    <div class="flex items-center gap-3">
                                        <div class="h-10 w-10 rounded-full bg-gradient-to-r from-blue-500 to-indigo-600 flex items-center justify-center text-white font-bold">
                                            {{ strtoupper(substr($user->name, 0, 1)) }}
                                        </div>
                                        <span class="font-medium">{{ $user->name }}</span>
                                    </div>
                                </td>
                                <td class="py-4 px-6">{{ $user->username }}</td>
                                <td class="py-4 px-6">
                                    <div class="flex flex-wrap gap-2">
                                        @forelse ($user->proyeks as $proyek)
                                            <span class="bg-gradient-to-r from-blue-100 to-indigo-100 text-blue-800 text-xs font-medium px-3 py-1.5 rounded-full flex items-center gap-1 transition-transform duration-200 hover:scale-105 hover:shadow-sm">
                                                <svg xmlns="http://www.w3.org/2000/svg" class="h-3 w-3" viewBox="0 0 20 20" fill="currentColor">
                                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-11a1 1 0 10-2 0v2H7a1 1 0 100 2h2v2a1 1 0 102 0v-2h2a1 1 0 100-2h-2V7z" clip-rule="evenodd" />
                                                </svg>
                                                {{ $proyek->nama_proyek }}
                                            </span>
                                        @empty
                                            <span class="text-gray-500 italic">Belum ada proyek</span>
                                        @endforelse
                                    </div>
                                </td>
                                <td class="py-4 px-4 text-center">
                                    <div class="flex justify-center gap-3">
                                        <a href="{{ route('users.edit', $user->id) }}" class="text-yellow-500 hover:text-yellow-700 font-medium flex items-center gap-1 bg-yellow-50 hover:bg-yellow-100 px-3 py-1.5 rounded-lg transition-all duration-200 hover:scale-105">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
                                                <path d="M13.586 3.586a2 2 0 112.828 2.828l-.793.793-2.828-2.828.793-.793zM11.379 5.793L3 14.172V17h2.828l8.38-8.379-2.83-2.828z" />
                                            </svg>
                                            Edit
                                        </a>
                                        
                                        {{-- [PERUBAHAN 2] Ganti <form> Hapus dengan <button> pemicu modal --}}
                                        <button type="button"
                                            @click="
                                                deleteModalAction = '{{ route('users.destroy', $user->id) }}';
                                                deleteModalTitle = 'Hapus User?';
                                                deleteModalMessage = 'Anda yakin ingin menghapus user <strong>{{ e($user->name) }}</strong> (Username: {{ e($user->username) }})? <br><br><span class=\'font-bold text-red-600\'>Tindakan ini permanen dan tidak bisa dibatalkan.</span>';
                                                showDeleteModal = true;
                                            "
                                            class="text-red-500 hover:text-red-700 font-medium flex items-center gap-1 bg-red-50 hover:bg-red-100 px-3 py-1.5 rounded-lg transition-all duration-200 hover:scale-105">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
                                                <path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
                                            </svg>
                                            Hapus
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-10 text-gray-500">
                                    <div class="flex flex-col items-center justify-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-16 w-16 text-gray-300 mb-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z" />
                                        </svg>
                                        <p class="text-lg font-medium">Belum ada data user</p>
                                        <p class="text-sm mt-1">Silakan tambahkan user baru</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-200 text-sm text-gray-600">
                Menampilkan {{ $users->count() }} pengguna
            </div>
        </div>
    </div>

    {{-- =================================== --}}
    {{-- [PERUBAHAN 3] MODAL KONFIRMASI HAPUS --}}
    {{-- (Ditempatkan di luar .container tapi di dalam x-data) --}}
    {{-- =================================== --}}
    <div x-show="showDeleteModal" 
         @keydown.escape.window="showDeleteModal = false"
         class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm flex items-center justify-center p-4 z-[9999]" 
         style="display: none;">
        
        <form :action="deleteModalAction" method="POST"
              @click.stop class="bg-white rounded-2xl shadow-2xl w-full max-w-md transform transition-all"
              x-show="showDeleteModal"
              x-transition:enter="ease-out duration-300"
              x-transition:enter-start="opacity-0 scale-95"
              x-transition:enter-end="opacity-100 scale-100"
              x-transition:leave="ease-in duration-200"
              x-transition:leave-start="opacity-100 scale-100"
              x-transition:leave-end="opacity-0 scale-95">
            
            @csrf
            @method('DELETE')

            <div class="p-6">
                <div class="flex items-start">
                    <div class="flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100">
                        <svg class="h-6 w-6 text-red-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                        </svg>
                    </div>
                    <div class="ml-4 text-left">
                        <h3 class="text-lg leading-6 font-bold text-gray-900" x-text="deleteModalTitle || 'Konfirmasi Hapus'"></h3>
                        <div class="mt-2">
                            <p class="text-sm text-gray-600" x-html="deleteModalMessage"></p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="bg-gray-50 px-6 py-4 flex justify-end space-x-3 rounded-b-2xl">
                <button type="button" 
                        @click="showDeleteModal = false" 
                        class="px-4 py-2 bg-white text-gray-700 font-medium rounded-lg border border-gray-300 hover:bg-gray-50 transition-colors">
                    Batal
                </button>
                <button type="submit" 
                        class="px-4 py-2 bg-red-600 text-white font-medium rounded-lg hover:bg-red-700 transition-colors flex items-center gap-1">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M9 2a1 1 0 00-.894.553L7.382 4H4a1 1 0 000 2v10a2 2 0 002 2h8a2 2 0 002-2V6a1 1 0 100-2h-3.382l-.724-1.447A1 1 0 0011 2H9zM7 8a1 1 0 012 0v6a1 1 0 11-2 0V8zm5-1a1 1 0 00-1 1v6a1 1 0 102 0V8a1 1 0 00-1-1z" clip-rule="evenodd" />
                    </svg>
                    Ya, Hapus
                </button>
            </div>
        </form>
    </div>

</div> {{-- Penutup 'div x-data' --}}
@endsection