@extends('layouts.Project')

@section('content')
<div class="space-y-8">
    <div>
        <h1 class="text-3xl font-bold text-gray-800">Tambah Anggota Baru</h1>
        <p class="text-gray-500 mt-1">Isi detail di bawah untuk menambahkan anggota ke tim.</p>
    </div>

    <div class="bg-white p-8 rounded-xl shadow-md border border-gray-200 max-w-2xl mx-auto">
        @if ($errors->any())
            <div class="mb-6 bg-red-50 border-l-4 border-red-400 text-red-700 p-4 rounded-lg" role="alert">
                <p class="font-bold">Oops! Ada beberapa kesalahan:</p>
                <ul class="mt-2 list-disc list-inside text-sm">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('anggota.store') }}" method="POST" class="space-y-6">
            @csrf
            
            <div>
                <label for="nama" class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap <span class="text-red-500">*</span></label>
                <input type="text" name="nama" id="nama" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('nama') }}" placeholder="Contoh: Budi Gunawan" required>
            </div>
            
            <div>
                <label for="posisi" class="block text-sm font-medium text-gray-700 mb-1">Posisi / Jabatan (Opsional)</label>
                <input type="text" name="posisi" id="posisi" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('posisi') }}" placeholder="Contoh: Staff Lapangan">
            </div>

            <div>
                <label for="no_hp" class="block text-sm font-medium text-gray-700 mb-1">No. Handphone (Opsional)</label>
                <input type="text" name="no_hp" id="no_hp" class="w-full p-2 border border-gray-300 rounded-lg" value="{{ old('no_hp') }}" placeholder="Contoh: 08123456789">
            </div>

            {{-- Tombol Aksi --}}
            <div class="flex justify-end space-x-4 pt-4 border-t border-gray-200 mt-6">
                <a href="{{ route('anggota.index') }}" class="px-4 py-2 bg-gray-300 text-gray-800 rounded-lg hover:bg-gray-400">Batal</a>
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">Simpan Anggota</button>
            </div>
        </form>
    </div>
</div>
@endsection