@extends('layouts.Project')

@section('content')
{{-- 
  Wrapper Alpine.js diletakkan di luar semua konten 
  untuk memastikan modal (z-index) bisa menutupi header. 
--}}
<div x-data="{ showDeleteModal: false, deleteModalAction: '', deleteModalMessage: '', deleteModalTitle: '' }">

    {{-- Konten utama halaman --}}
    <div class="space-y-8">
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">Manajemen Anggota</h1>
                <p class="text-gray-500 mt-1">Kelola daftar anggota tim Anda.</p>
            </div>
            @if(Auth::user()->role == 'admin')
                <a href="{{ route('anggota.create') }}" class="px-4 py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700">
                    + Tambah Anggota
                </a>
            @endif
        </div>

        {{-- Notifikasi Sukses --}}
        @if(session('success'))
            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded-lg" role="alert">
                <p>{{ session('success') }}</p>
            </div>
        @endif
        
        {{-- Notifikasi Error --}}
        @if(session('error'))
            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded-lg" role="alert">
                <p>{{ session('error') }}</p>
            </div>
        @endif


        {{-- Tabel Data Anggota --}}
        <div class="bg-white p-6 rounded-xl shadow-lg border border-gray-200">
            <div class="overflow-x-auto">
                <table class="min-w-full bg-white">
                    <thead class="bg-gray-100">
                        <tr>
                            <th class="py-3 px-4 text-left text-sm font-semibold text-gray-600 uppercase">Nama Anggota</th>
                            <th class="py-3 px-4 text-left text-sm font-semibold text-gray-600 uppercase">Posisi/Jabatan</th>
                            <th class="py-3 px-4 text-left text-sm font-semibold text-gray-600 uppercase">No. Handphone</th>
                            <th class="py-3 px-4 text-left text-sm font-semibold text-gray-600 uppercase">Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200">
                        @forelse ($anggota as $member)
                        <tr class="hover:bg-gray-50">
                            <td class="py-3 px-4">
                                <div class="font-medium text-gray-800">{{ $member->nama }}</div>
                            </td>
                            <td class="py-3 px-4 text-gray-600">{{ $member->posisi ?? '-' }}</td>
                            <td class="py-3 px-4 text-gray-600">{{ $member->no_hp ?? '-' }}</td>
                            <td class="py-3 px-4 flex items-center space-x-2">
                                <a href="{{ route('anggota.edit', $member->id) }}" class="bg-yellow-500 hover:bg-yellow-600 text-white font-bold py-1 px-3 rounded text-xs">Edit</a>
                                
                                {{-- Tombol Hapus --}}
                                <button type="button"
                                    @click="
                                        deleteModalAction = '{{ route('anggota.destroy', $member->id) }}';
                                        deleteModalTitle = 'Hapus Anggota?';
                                        deleteModalMessage = 'Yakin hapus anggota: <strong>{{ e($member->nama) }}</strong>? <br><small>Task yang ditugaskan padanya akan menjadi tidak tertugaskan (NULL).</small>';
                                        showDeleteModal = true;
                                    "
                                    class="bg-red-500 hover:bg-red-600 text-white font-bold py-1 px-3 rounded text-xs">
                                    Hapus
                                </button>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="text-center py-6 text-gray-500">
                                Belum ada anggota yang ditambahkan.
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Pagination --}}
            <div class="mt-6">
                {{ $anggota->links() }}
            </div>
        </div>
    </div> {{-- Penutup 'space-y-8' --}}


    {{-- =================================== --}}
    {{-- MODAL KONFIRMASI HAPUS (SAMA SEPERTI tasks.index) --}}
    {{-- =================================== --}}
    <div x-show="showDeleteModal" 
         @keydown.escape.window="showDeleteModal = false"
         class="fixed inset-0 bg-black bg-opacity-70 flex items-center justify-center p-4 z-[9999]" 
         style="display: none;">
        
        <form :action="deleteModalAction" method="POST"
              @click.stop class="bg-white rounded-xl shadow-2xl w-full max-w-md transform transition-all"
              x-show="showDeleteModal"
              x-transition:enter="ease-out duration-300"
              x-transition:enter-start="opacity-0 scale-90"
              x-transition:enter-end="opacity-100 scale-100"
              x-transition:leave="ease-in duration-200"
              x-transition:leave-start="opacity-100 scale-100"
              x-transition:leave-end="opacity-0 scale-90">
            
            @csrf
            @method('DELETE')

            <div class="p-6">
                <div class="flex">
                    <div class="flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100 sm:mx-0 sm:h-10 sm:w-10">
                        <svg class="h-6 w-6 text-red-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                        </svg>
                    </div>
                    <div class="ml-4 text-left">
                        <h3 class="text-lg leading-6 font-bold text-gray-900" x-text="deleteModalTitle"></h3>
                        <div class="mt-2">
                            <p class="text-sm text-gray-600" x-html="deleteModalMessage"></p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="bg-gray-50 px-6 py-4 flex justify-end space-x-3 rounded-b-xl">
                <button type="button" 
                        @click="showDeleteModal = false" 
                        class="px-4 py-2 bg-white text-gray-700 font-semibold rounded-lg border border-gray-300 hover:bg-gray-50">
                    Batal
                </button>
                <button type="submit" 
                        class="px-4 py-2 bg-red-600 text-white font-semibold rounded-lg hover:bg-red-700">
                    Ya, Hapus
                </button>
            </div>
        </form>
    </div>
</div> {{-- Penutup 'div x-data' --}}
@endsection