<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Login - Tohjaya Contractor</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <!-- Style untuk tab yang modern tanpa garis bawah -->
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        
        /* Style untuk tab yang lebih modern dengan shadow */
        .tab-container {
            position: relative;
            margin-bottom: 2rem;
            background: #f9fafb;
            border-radius: 12px;
            padding: 6px;
            display: flex;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }
        
        .tab-btn {
            @apply relative py-3 px-4 text-center font-medium text-gray-500 cursor-pointer transition-all duration-300 whitespace-nowrap rounded-lg;
            flex: 1;
            z-index: 1;
        }
        
        .tab-btn.active {
            @apply text-blue-600 bg-white shadow-md;
            transform: translateY(-2px);
        }
        
        .tab-btn:hover:not(.active) {
            @apply text-gray-700 bg-gray-100;
        }
        
        /* Style untuk tombol login yang lebih modern */
        .login-button {
            @apply relative overflow-hidden;
            transition: all 0.3s ease;
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
        }
        
        .login-button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s;
        }
        
        .login-button:hover::before {
            left: 100%;
        }
        
        .login-button:hover {
            background: linear-gradient(135deg, #1d4ed8 0%, #1e40af 100%);
            box-shadow: 0 10px 15px -3px rgba(37, 99, 235, 0.3), 0 4px 6px -2px rgba(37, 99, 235, 0.15);
        }
        
        /* Animasi untuk form input */
        .form-input {
            transition: all 0.3s ease;
        }
        
        .form-input:focus {
            transform: translateY(-2px);
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        
        /* Efek untuk logo */
        .logo-container {
            transition: all 0.3s ease;
        }
        
        .logo-container:hover {
            transform: scale(1.05);
        }
        
        /* Efek untuk bagian kanan */
        .right-side {
            background: linear-gradient(135deg, #2563eb 0%, #1e40af 100%);
            position: relative;
            overflow: hidden;
        }
        
        .right-side::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 70%);
            animation: pulse 15s infinite linear;
        }
        
        @keyframes pulse {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Efek untuk ikon di tab */
        .tab-icon {
            transition: all 0.3s ease;
        }
        
        .tab-btn.active .tab-icon {
            transform: scale(1.1);
        }
    </style>
</head>
<body class="antialiased bg-white">
    <div class="flex flex-col lg:flex-row overflow-hidden min-h-screen">
        
        <div class="w-full lg:w-1/2 p-8 sm:p-12 flex flex-col justify-center">
            
            <!-- Logo Anda -->
            <div class="flex items-center mb-8 logo-container">
                <div class="w-12 h-12 bg-blue-600 rounded-full mr-4 flex-shrink-0 flex items-center justify-center shadow-md">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path></svg>
                </div>
                <span class="text-2xl font-bold text-gray-800">Tohjaya.contractor</span>
            </div>

            <!-- Pesan Selamat Datang -->
            <h2 class="text-4xl font-extrabold text-gray-900 mb-4">Welcome Back!</h2>
            <p class="text-gray-500 mb-6">Please select your login portal.</p>

            <!-- NAVIGASI TAB YANG DIPERBAIKI - TANPA GARIS BAWAH -->
            <div class="tab-container">
                <button class="tab-btn active" data-portal="kontraktor" data-title="Login sebagai Kontraktor">
                    <span class="inline-flex items-center justify-center">
                        <svg class="w-5 h-5 mr-2 tab-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path></svg>
                        Kontraktor
                    </span>
                </button>
                <button class="tab-btn" data-portal="tim" data-title="Login sebagai Tim Proyek">
                    <span class="inline-flex items-center justify-center">
                        <svg class="w-5 h-5 mr-2 tab-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656-.126-1.283-.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path></svg>
                        Manajemen Proyek
                    </span>
                </button>
                <button class="tab-btn" data-portal="owner" data-title="Login sebagai Owner (Klien)">
                    <span class="inline-flex items-center justify-center">
                        <svg class="w-5 h-5 mr-2 tab-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                        Owner (Klien)
                    </span>
                </button>
            </div>
            
            <!-- Error Messages -->
            @if ($errors->any())
                <div class="mb-4 bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-lg text-sm relative" role="alert">
                    <strong class="font-bold">Oops! </strong>
                    <span class="block sm:inline">{{ $errors->first() }}</span>
                </div>
            @endif

            <!-- BENTUK FORM (SAMA UNTUK SEMUA) -->
            <form method="POST" action="{{ route('login.store') }}" class="space-y-6">
                @csrf

                <!-- INPUT TERSEMBUNYI UNTUK MEMPERBAIKI BUG REDIRECT -->
                <input type="hidden" name="login_portal" id="login_portal" value="kontraktor">

                <!-- Username -->
                <div>
                    <label for="username" class="block text-gray-600 text-sm font-bold mb-2">USERNAME</label>
                    <div class="relative">
                        <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                            <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path></svg>
                        </span>
                        <input id="username" class="bg-gray-50 border border-gray-300 text-gray-900 text-base rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-3 transition duration-300 form-input" 
                               type="text" name="username" value="{{ old('username') }}" required autofocus placeholder="Enter your username" />
                    </div>
                </div>

                <!-- Password -->
                <div>
                    <label for="password" class="block text-gray-600 text-sm font-bold mb-2">PASSWORD</label>
                     <div class="relative">
                         <span class="absolute inset-y-0 left-0 flex items-center pl-3">
                             <svg class="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path></svg>
                         </span>
                        <input id="password" class="bg-gray-50 border border-gray-300 text-gray-900 text-base rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full pl-10 p-3 transition duration-300 form-input"
                               type="password" name="password" required autocomplete="current-password" placeholder="Enter your password"/>
                    </div>
                </div>
                
                <!-- Remember Me & Forgot Password -->
                <div class="flex items-center justify-between text-sm">
                    <div class="flex items-center">
                        <input id="remember_me" type="checkbox" class="h-4 w-4 rounded border-gray-300 text-blue-600 focus:ring-blue-500" name="remember">
                        <label for="remember_me" class="ml-2 text-gray-600">Remember me</label>
                    </div>
                    <!-- <a href="#" class="font-medium text-blue-600 hover:underline">Forgot password?</a> -->
                </div>

                <!-- Tombol Login (Dinamis) -->
                <div>
                    <button id="loginButton" type="submit" class="w-full login-button text-white font-bold py-3 px-4 rounded-xl focus:outline-none focus:shadow-outline transition duration-300 transform hover:scale-105 text-lg shadow-lg">
                        <span class="flex items-center justify-center">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path></svg>
                            Login sebagai Kontraktor
                        </span>
                    </button>
                </div>
            </form>
        </div>

        <!-- Bagian Kanan (Gambar) -->
        <div class="hidden lg:flex relative w-full lg:w-1/2 flex-col justify-center items-center text-white right-side">
            <div class="text-center z-10 p-8">
                <div class="bg-white/20 rounded-full p-4 inline-block mb-6 backdrop-blur-sm border border-white/30">
                    <svg class="w-20 h-20 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path></svg>
                </div>
                <h3 class="text-4xl font-black tracking-widest leading-tight">TOHJAYA.CONTRACTOR</h3>
                <p class="text-white/80 mt-4">Building The Future, Restoring The Past.</p>
            </div>
        </div>

    </div>

    <!-- JAVASCRIPT UNTUK TAB -->
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const tabButtons = document.querySelectorAll('.tab-btn');
            const loginButton = document.getElementById('loginButton');
            const hiddenPortalInput = document.getElementById('login_portal');

            tabButtons.forEach(button => {
                button.addEventListener('click', () => {
                    // Hapus 'active' dari semua tombol
                    tabButtons.forEach(btn => btn.classList.remove('active'));
                    
                    // Tambahkan 'active' ke tombol yang diklik
                    button.classList.add('active');
                    
                    // Update nilai input tersembunyi
                    const portalValue = button.getAttribute('data-portal');
                    hiddenPortalInput.value = portalValue;

                    // Ubah teks tombol login
                    const buttonTitle = button.getAttribute('data-title');
                    loginButton.querySelector('span').innerHTML = `
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h7a3 3 0 013 3v1"></path></svg>
                        ${buttonTitle}
                    `;
                });
            });
        });
    </script>

</body>
</html>