@extends('layouts.app')

@section('content')
<div class="space-y-8">
    <div>
        <h1 class="text-3xl font-bold text-gray-800">Input Data Awal</h1>
        <p class="text-gray-500 mt-1">Impor data pengeluaran dan upah tukang untuk proyek yang ada.</p>
    </div>

    {{-- ====================================================== --}}
    {{-- Notifikasi (Dengan Ikon) --}}
    {{-- ====================================================== --}}
    @if(session('success'))
        <div class="flex items-start bg-green-50 border-l-4 border-green-500 text-green-800 p-4 rounded-lg shadow" role="alert">
            <svg class="h-6 w-6 text-green-600 mr-3 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
            <div>
                <p class="font-bold">Sukses</p>
                <p class="text-sm">{!! nl2br(e(session('success'))) !!}</p>
            </div>
        </div>
    @endif

    @if(session('error'))
        <div class="flex items-start bg-red-50 border-l-4 border-red-500 text-red-800 p-4 rounded-lg shadow" role="alert">
            <svg class="h-6 w-6 text-red-600 mr-3 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
            <div>
                <p class="font-bold">Error</p>
                <p class="text-sm">{{ session('error') }}</p>
            </div>
        </div>
    @endif

    @if(session('csv_errors'))
        <div class="flex items-start bg-yellow-50 border-l-4 border-yellow-500 text-yellow-800 p-4 rounded-lg shadow" role="alert">
            <svg class="h-6 w-6 text-yellow-600 mr-3 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" /></svg>
            <div>
                <p class="font-bold">Peringatan (Beberapa baris gagal diimpor):</p>
                <ul class="list-disc list-inside text-sm mt-2">
                    @foreach(session('csv_errors') as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        </div>
    @endif

    {{-- ====================================================== --}}
    {{-- Kotak Info Template --}}
    {{-- ====================================================== --}}
    <div class="flex items-start bg-blue-50 border-l-4 border-blue-400 text-blue-800 p-4 rounded-lg shadow">
        <svg class="h-6 w-6 text-blue-600 mr-3 flex-shrink-0" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
        <div>
            <p class="font-bold">Butuh Template?</p>
            <p class="text-sm mt-1 mb-3">Gunakan template ini untuk memastikan format data benar. Anda dapat mengunduh dan mengisinya sebelum melanjutkan ke langkah impor di bawah.</p>
            <div class="flex flex-wrap gap-4">
                <a href="{{ route('inputdata.downloadTemplate', ['template' => 'pengeluaran']) }}" 
                   class="inline-flex items-center gap-2 bg-green-600 text-white font-bold py-2 px-4 rounded-lg hover:bg-green-700 transition duration-300">
                   <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M3 17a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm3.293-7.707a1 1 0 011.414 0L9 10.586V3a1 1 0 112 0v7.586l1.293-1.293a1 1 0 111.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" /></svg>
                   Template Pengeluaran
                </a>
                <a href="{{ route('inputdata.downloadTemplate', ['template' => 'tukang']) }}" 
                   class="inline-flex items-center gap-2 bg-yellow-600 text-white font-bold py-2 px-4 rounded-lg hover:bg-yellow-700 transition duration-300">
                   <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M3 17a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm3.293-7.707a1 1 0 011.414 0L9 10.586V3a1 1 0 112 0v7.586l1.293-1.293a1 1 0 111.414 1.414l-3 3a1 1 0 01-1.414 0l-3-3a1 1 0 010-1.414z" clip-rule="evenodd" /></svg>
                   Template Tukang
                </a>
            </div>
        </div>
    </div>

    {{-- ====================================================== --}}
    {{-- Form Wizard (Layout Baru) --}}
    {{-- ====================================================== --}}
    <div class="bg-white p-6 sm:p-8 rounded-xl shadow-lg border border-gray-200">
        
        <form x-data="{ id_proyek: '', file_pengeluaran: null, file_tukang: null }"
              action="{{ route('inputdata.parse') }}" method="POST" enctype="multipart/form-data" class="space-y-8">
            @csrf

            {{-- LANGKAH 1: KONFIGURASI PROYEK --}}
            <div class="space-y-6">
                <div class="flex items-center gap-3">
                    <span class="flex-shrink-0 w-8 h-8 rounded-full bg-blue-600 text-white flex items-center justify-center font-bold">1</span>
                    <h2 class="text-xl font-semibold text-gray-800">Pilih Proyek Induk</h2>
                </div>
                <div class="pl-11">
                    <label for="id_proyek" class="block text-sm font-medium text-gray-700 mb-1">
                        Proyek Induk <span class="text-red-600 font-bold">*Wajib</span>
                    </label>
                    <select name="id_proyek" id="id_proyek" required x-model="id_proyek"
                            class="block w-full max-w-lg mt-1 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="">-- Pilih Proyek --</option>
                        @foreach($proyeks as $proyek)
                            <option value="{{ $proyek->id_proyek }}">
                                {{ $proyek->nama_proyek }} (Klien: {{ $proyek->klien }})
                            </option>
                        @endforeach
                    </select>
                    @error('id_proyek') <span class="text-red-500 text-sm mt-1">{{ $message }}</span> @enderror
                </div>
            </div>

            <hr class="border-gray-200">

            {{-- LANGKAH 2: UPLOAD FILE (Grid 2x2) --}}
            <div class="space-y-6">
                <div class="flex items-center gap-3">
                    <span class="flex-shrink-0 w-8 h-8 rounded-full bg-blue-600 text-white flex items-center justify-center font-bold">2</span>
                    <h2 class="text-xl font-semibold text-gray-800">Unggah File <span class="text-base font-normal text-gray-500">(Opsional)</span></h2>
                </div>
                <p class="text-gray-600 pl-11">
                    Anda dapat mengunggah satu atau kedua file sekaligus.
                </p>
                
                {{-- 
                  Grid 2x2: 
                  Di mobile (cols-1), urutannya: Vendor, Pengeluaran, Tukang.
                  Di desktop (cols-2), urutannya:
                  [Vendor]      | [Placeholder]
                  [Pengeluaran] | [Tukang]
                --}}
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6 pl-11">
                    
                    {{-- SEL 1: VENDOR DROPDOWN --}}
                    <div>
                        <label for="nama_vendor" class="block text-sm font-medium text-gray-700 mb-1">
                            Vendor/Toko
                            <span class="text-gray-500">(Wajib jika unggah pengeluaran)</span>
                        </label>
                        <select name="nama_vendor" id="nama_vendor"
                                :required="file_pengeluaran !== null"
                                class="block w-full mt-1 rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="">-- Pilih Vendor --</option>
                            @foreach($vendors as $vendor)
                                <option value="{{ $vendor->nama_vendor }}">
                                    {{ $vendor->nama_vendor }}
                                </option>
                            @endforeach
                        </select>
                        @error('nama_vendor') <span class="text-red-500 text-sm mt-1">{{ $message }}</span> @enderror
                    </div>

                    {{-- SEL 2: PLACEHOLDER KOSONG --}}
                    {{-- Muncul di desktop (md:block) untuk mengisi sel [1,2], --}}
                    {{-- sehingga mendorong Dropzone Tukang ke baris kedua. --}}
                    <div class="hidden md:block">
                        {{-- Kosong --}}
                    </div>

                    {{-- SEL 3: DROPZONE PENGELUARAN --}}
                    <div x-data="{ dragging: false, filename: '' }" @dragover.prevent="dragging = true" @dragleave.prevent="dragging = false" @drop.prevent="dragging = false; filename = $event.dataTransfer.files[0].name; $refs.fileInputPengeluaran.files = $event.dataTransfer.files; file_pengeluaran = $event.dataTransfer.files[0];" class="relative">
                        <label for="file_pengeluaran" 
                               :class="{'border-blue-500 bg-blue-50': dragging, 'border-gray-300 bg-gray-50': !dragging}"
                               class="flex flex-col items-center justify-center w-full h-48 border-2 border-dashed rounded-lg cursor-pointer hover:bg-gray-100 transition duration-300">
                            <div class="flex flex-col items-center justify-center pt-5 pb-6 text-center">
                                <svg class="w-10 h-10 mb-3 text-green-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75l3 3m0 0l3-3m-3 3v-7.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                                <p class="mb-2 text-sm font-semibold text-green-800">File Pengeluaran (.csv)</p>
                                <p class="text-xs text-gray-500">Klik atau seret file ke sini</p>
                                <template x-if="filename">
                                    <p class="text-xs text-blue-700 font-medium mt-2 flex items-center gap-1">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" /></svg>
                                        <span x-text="filename"></span>
                                    </p>
                                </template>
                            </div>
                        </label>
                        <input x-ref="fileInputPengeluaran" @change="filename = $event.target.files[0] ? $event.target.files[0].name : ''; file_pengeluaran = $event.target.files[0];"
                               type="file" name="file_pengeluaran" id="file_pengeluaran" class="hidden" accept=".csv">
                        @error('file_pengeluaran') <span class="text-red-500 text-sm mt-1">{{ $message }}</span> @enderror
                    </div>

                    {{-- SEL 4: DROPZONE TUKANG --}}
                    <div x-data="{ dragging: false, filename: '' }" @dragover.prevent="dragging = true" @dragleave.prevent="dragging = false" @drop.prevent="dragging = false; filename = $event.dataTransfer.files[0].name; $refs.fileInputTukang.files = $event.dataTransfer.files; file_tukang = $event.dataTransfer.files[0];" class="relative">
                        <label for="file_tukang" 
                               :class="{'border-blue-500 bg-blue-50': dragging, 'border-gray-300 bg-gray-50': !dragging}"
                               class="flex flex-col items-center justify-center w-full h-48 border-2 border-dashed rounded-lg cursor-pointer hover:bg-gray-100 transition duration-300">
                            <div class="flex flex-col items-center justify-center pt-5 pb-6 text-center">
                                <svg class="w-10 h-10 mb-3 text-yellow-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75l3 3m0 0l3-3m-3 3v-7.5M21 12a9 9 0 11-18 0 9 9 0 0118 0z" /></svg>
                                <p class="mb-2 text-sm font-semibold text-yellow-800">File Upah Tukang (.csv)</p>
                                <p class="text-xs text-gray-500">Klik atau seret file ke sini</p>
                                <template x-if="filename">
                                    <p class="text-xs text-blue-700 font-medium mt-2 flex items-center gap-1">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" /></svg>
                                        <span x-text="filename"></span>
                                    </p>
                                </template>
                            </div>
                        </label>
                        <input x-ref="fileInputTukang" @change="filename = $event.target.files[0] ? $event.target.files[0].name : ''; file_tukang = $event.target.files[0];"
                               type="file" name="file_tukang" id="file_tukang" class="hidden" accept=".csv">
                        @error('file_tukang') <span class="text-red-500 text-sm mt-1">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>


            {{-- Tombol Submit --}}
            <div class="pt-4 border-t border-gray-200">
                <button type="submit" 
                        {{-- Tombol hanya aktif jika Proyek dipilih DAN salah satu file diupload --}}
                        :disabled="!id_proyek || (!file_pengeluaran && !file_tukang)"
                        class="w-full inline-flex items-center justify-center gap-2 bg-blue-600 text-white font-bold py-3 px-6 rounded-lg hover:bg-blue-700 transition duration-300 text-base
                               disabled:opacity-50 disabled:cursor-not-allowed">
                    Lanjut ke Penyesuaian
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-8.707l-3-3a1 1 0 00-1.414 1.414L10.586 9H7a1 1 0 100 2h3.586l-1.293 1.293a1 1 0 101.414 1.414l3-3a1 1 0 000-1.414z" clip-rule="evenodd" /></svg>
                </button>
                
                {{-- Info tambahan untuk pengguna --}}
                <p x-show="!id_proyek || (!file_pengeluaran && !file_tukang)" class="text-center text-sm text-gray-500 mt-3">
                    * Harap pilih Proyek Induk dan unggah minimal satu file (Pengeluaran atau Tukang) untuk melanjutkan.
                </p>
            </div>
        </form>
    </div>
</div>
@endsection