@extends('layouts.app')

@section('content')
<div x-data="{ 
    viewMode: localStorage.getItem('proyekViewMode') || 'grid',
    setView(mode) {
        this.viewMode = mode;
        localStorage.setItem('proyekViewMode', mode);
    },
    showDeleteModal: false, 
    deleteModalAction: '', 
    deleteModalMessage: '', 
    deleteModalTitle: '' 
}">

    <div class="space-y-8">
        {{-- Header Halaman --}}
        <div class="flex flex-col md:flex-row justify-between items-center gap-4">
            <div>
                <h1 class="text-3xl font-bold text-gray-800">Daftar Proyek</h1>
                <p class="text-gray-500 mt-1">Kelola semua proyek yang sedang berjalan, ditunda, atau telah selesai.</p>
            </div>
            
            <div class="flex flex-col sm:flex-row gap-3 items-center w-full md:w-auto">
                <a href="{{ route('proyek.create') }}" class="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg flex items-center transition duration-150 ease-in-out w-full sm:w-auto justify-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110 2h3V6a1 1 0 011-1z" clip-rule="evenodd" />
                    </svg>
                    Tambah Proyek
                </a>
                
                {{-- View Toggler --}}
                <div class="bg-gray-100 p-1 rounded-lg flex items-center border border-gray-200">
                    <button @click="setView('grid')"
                            :class="viewMode === 'grid' ? 'bg-white text-blue-600 shadow-sm' : 'text-gray-500 hover:text-gray-700'"
                            class="p-2 rounded-md transition duration-150 ease-in-out flex items-center justify-center"
                            title="Tampilan Grid">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
                        </svg>
                    </button>
                    <button @click="setView('list')"
                            :class="viewMode === 'list' ? 'bg-white text-blue-600 shadow-sm' : 'text-gray-500 hover:text-gray-700'"
                            class="p-2 rounded-md transition duration-150 ease-in-out flex items-center justify-center"
                            title="Tampilan List">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                </div>
            </div>
        </div>
        
        {{-- Search & Filter Section --}}
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4">
            <form action="{{ route('proyek.index') }}" method="GET">
                @if(request('sort_by'))
                    <input type="hidden" name="sort_by" value="{{ request('sort_by') }}">
                    <input type="hidden" name="order" value="{{ request('order') }}">
                @endif
                
                <div class="flex flex-col md:flex-row gap-3">
                    <div class="flex-1 relative">
                        <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                            <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd" />
                            </svg>
                        </div>
                        <input type="text" 
                               name="search" 
                               value="{{ request('search') }}" 
                               placeholder="Cari nama proyek, PIC..." 
                               class="pl-10 block w-full rounded-lg border-gray-300 shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm h-11">
                    </div>

                    <div class="w-full md:w-48">
                        <select name="status" class="block w-full rounded-lg border-gray-300 shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm h-11 cursor-pointer">
                            <option value="">- Semua Status -</option>
                            <option value="Berjalan" {{ request('status') == 'Berjalan' ? 'selected' : '' }}>Berjalan</option>
                            <option value="Selesai" {{ request('status') == 'Selesai' ? 'selected' : '' }}>Selesai</option>
                            <option value="Ditunda" {{ request('status') == 'Ditunda' ? 'selected' : '' }}>Ditunda</option>
                        </select>
                    </div>

                    <button type="submit" class="w-full md:w-auto bg-gray-800 hover:bg-gray-900 text-white font-medium px-6 rounded-lg transition duration-150 ease-in-out h-11 flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M3 3a1 1 0 011-1h12a1 1 0 011 1v3a1 1 0 01-.293.707L12 11.414V15a1 1 0 01-.293.707l-2 2A1 1 0 018 17v-5.586L3.293 6.707A1 1 0 013 6V3z" clip-rule="evenodd" />
                        </svg>
                        Filter
                    </button>
                    
                    @if(request()->hasAny(['search', 'status']))
                        <a href="{{ route('proyek.index') }}" class="w-full md:w-auto bg-gray-100 hover:bg-gray-200 text-gray-600 font-medium px-4 rounded-lg transition duration-150 ease-in-out h-11 flex items-center justify-center" title="Reset Filter">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
                            </svg>
                        </a>
                    @endif
                </div>
            </form>
        </div>


        {{-- Notifikasi --}}
        @if(session('success'))
            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 rounded-lg" role="alert">
                <p class="font-bold">Sukses!</p>
                <p>{{ session('success') }}</p>
            </div>
        @endif
        @if(session('error'))
            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 rounded-lg" role="alert">
                <p class="font-bold">Gagal!</p>
                <p>{{ session('error') }}</p>
            </div>
        @endif

        {{-- =================================== --}}
        {{-- TAMPILAN GRID VIEW (KARTU)         --}}
        {{-- =================================== --}}
        <div x-show="viewMode === 'grid'"
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 transform scale-95"
             x-transition:enter-end="opacity-100 transform scale-100"
             class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            
            @forelse ($proyeks as $proyek)
                @php
                    $sisaAnggaran = $proyek->nilai_kontrak - ($proyek->total_pengeluaran ?? 0);
                @endphp
                <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden flex flex-col transition-shadow duration-300 hover:shadow-2xl">
                    {{-- Header Kartu --}}
                    <div class="p-5 border-b border-gray-100">
                        <div class="flex justify-between items-start mb-2">
                            <h3 class="text-lg font-bold text-gray-900 line-clamp-2" title="{{ $proyek->nama_proyek }}">
                                {{ $proyek->nama_proyek }}
                            </h3>
                            <span class="px-2.5 py-0.5 rounded-full text-xs font-semibold whitespace-nowrap ml-2
                                @if($proyek->status == 'Selesai') bg-green-100 text-green-800
                                @elseif($proyek->status == 'Ditunda') bg-red-100 text-red-800
                                @else bg-yellow-100 text-yellow-800 @endif">
                                {{ $proyek->status }}
                            </span>
                        </div>
                        <p class="text-sm text-gray-500">PIC: {{ $proyek->pic }}</p>
                    </div>

                    {{-- [DIUBAH] Body Kartu (Grid 2x2 Simetris) --}}
                    <div class="p-5 flex-1">
                        <div class="grid grid-cols-2 gap-4">
                            <div class="bg-gray-50 p-3 rounded-lg text-center">
                                <p class="text-xs text-gray-500 uppercase font-semibold">Anggaran</p>
                                <p class="text-sm font-bold text-gray-800">Rp. {{ number_format($proyek->nilai_kontrak, 0, ',', '.') }}</p>
                            </div>
                            <div class="bg-gray-50 p-3 rounded-lg text-center">
                                <p class="text-xs text-gray-500 uppercase font-semibold">Pengeluaran</p>
                                <p class="text-sm font-bold text-red-600">Rp. {{ number_format($proyek->total_pengeluaran ?? 0, 0, ',', '.') }}</p>
                            </div>
                            <div class="bg-gray-50 p-3 rounded-lg text-center">
                                <p class="text-xs text-gray-500 uppercase font-semibold">Sisa Anggaran</p>
                                <p class="text-sm font-bold {{ $sisaAnggaran < 0 ? 'text-red-600' : 'text-green-600' }}">
                                    Rp. {{ number_format($sisaAnggaran, 0, ',', '.') }}
                                </p>
                            </div>
                            <div class="bg-gray-50 p-3 rounded-lg text-center">
                                <p class="text-xs text-gray-500 uppercase font-semibold">Sisa Waktu</p>
                                <p class="text-sm font-bold text-gray-800">{{ $proyek->sisa_waktu }}</p>
                            </div>
                        </div>
                    </div>

                    {{-- Footer Kartu (Aksi) --}}
                    <div class="bg-gray-50 px-5 py-4 border-t border-gray-100 flex items-center gap-2">
                        <a href="{{ route('proyek.show', $proyek->id_proyek) }}" class="flex-1 text-center bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-3 rounded-lg text-sm transition-colors">
                            View Detail
                        </a>
                        <a href="{{ route('proyek.edit', $proyek->id_proyek) }}" class="p-2 text-gray-500 hover:text-yellow-600 hover:bg-yellow-100 rounded-lg transition-colors" title="Edit">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path></svg>
                        </a>
                        
                        <button type="button" 
                            @click="
                                deleteModalAction = '{{ route('proyek.destroy', $proyek->id_proyek) }}';
                                deleteModalTitle = 'Arsipkan Proyek?';
                                deleteModalMessage = 'Anda yakin ingin mengarsipkan proyek <strong>{{ e($proyek->nama_proyek) }}</strong>? <br><br>Proyek akan disembunyikan dari daftar, namun data pengeluarannya tetap aman.';
                                showDeleteModal = true;
                            "
                            class="p-2 text-gray-500 hover:text-red-600 hover:bg-red-100 rounded-lg transition-colors" title="Arsipkan">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 8h14M5 8a2 2 0 110-4h14a2 2 0 110 4M5 8v10a2 2 0 002 2h10a2 2 0 002-2V8m-9 4h4"></path></svg>
                        </button>
                    </div>
                </div>
            @empty
                <div class="col-span-full flex flex-col items-center justify-center p-12 bg-white rounded-xl border border-dashed border-gray-300 text-gray-500">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-16 w-16 text-gray-300 mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5"></path></svg>
                    <h3 class="text-lg font-medium text-gray-900">Belum ada data proyek</h3>
                    <p class="mt-1 text-sm">Tidak ada proyek yang cocok dengan filter Anda.</p>
                </div>
            @endforelse
        </div>
        
        {{-- =================================== --}}
        {{-- TAMPILAN LIST (TABEL)              --}}
        {{-- =================================== --}}
        <div x-show="viewMode === 'list'" 
             style="display: none;"
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100">
            
            <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="min-w-full bg-white">
                        
                        {{-- [PENTING] Header Sorting (Fungsi Tetap Terjaga) --}}
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="py-3 px-4 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">
                                    @php $newOrder = ($sortBy == 'nama_proyek' && $order == 'asc') ? 'desc' : 'asc'; @endphp
                                    <a href="{{ route('proyek.index', array_merge(request()->query(), ['sort_by' => 'nama_proyek', 'order' => $newOrder])) }}" 
                                       class="flex items-center hover:text-blue-700 {{ $sortBy == 'nama_proyek' ? 'text-blue-600 font-bold' : '' }}">
                                        Nama Proyek
                                        <span class="ml-1.5">@if ($sortBy == 'nama_proyek') {!! $order == 'asc' ? '↑' : '↓' !!} @else <span class="text-gray-300">↕</span> @endif</span>
                                    </a>
                                </th>
                                <th class="py-3 px-4 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">
                                    @php $newOrder = ($sortBy == 'nilai_kontrak' && $order == 'asc') ? 'desc' : 'asc'; @endphp
                                    <a href="{{ route('proyek.index', array_merge(request()->query(), ['sort_by' => 'nilai_kontrak', 'order' => $newOrder])) }}" 
                                       class="flex items-center hover:text-blue-700 {{ $sortBy == 'nilai_kontrak' ? 'text-blue-600 font-bold' : '' }}">
                                        Anggaran
                                        <span class="ml-1.5">@if ($sortBy == 'nilai_kontrak') {!! $order == 'asc' ? '↑' : '↓' !!} @else <span class="text-gray-300">↕</span> @endif</span>
                                    </a>
                                </th>
                                <th class="py-3 px-4 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">
                                    @php $newOrder = ($sortBy == 'total_pengeluaran' && $order == 'asc') ? 'desc' : 'asc'; @endphp
                                    <a href="{{ route('proyek.index', array_merge(request()->query(), ['sort_by' => 'total_pengeluaran', 'order' => $newOrder])) }}" 
                                       class="flex items-center hover:text-blue-700 {{ $sortBy == 'total_pengeluaran' ? 'text-blue-600 font-bold' : '' }}">
                                        Total Pengeluaran
                                        <span class="ml-1.5">@if ($sortBy == 'total_pengeluaran') {!! $order == 'asc' ? '↑' : '↓' !!} @else <span class="text-gray-300">↕</span> @endif</span>
                                    </a>
                                </th>
                                <th class="py-3 px-4 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">
                                    @php $newOrder = ($sortBy == 'sisa_anggaran' && $order == 'asc') ? 'desc' : 'asc'; @endphp
                                    <a href="{{ route('proyek.index', array_merge(request()->query(), ['sort_by' => 'sisa_anggaran', 'order' => $newOrder])) }}" 
                                       class="flex items-center hover:text-blue-700 {{ $sortBy == 'sisa_anggaran' ? 'text-blue-600 font-bold' : '' }}">
                                        Sisa Anggaran
                                        <span class="ml-1.5">@if ($sortBy == 'sisa_anggaran') {!! $order == 'asc' ? '↑' : '↓' !!} @else <span class="text-gray-300">↕</span> @endif</span>
                                    </a>
                                </th>
                                <th class="py-3 px-4 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">
                                    @php $newOrder = ($sortBy == 'target_selesai' && $order == 'asc') ? 'desc' : 'asc'; @endphp
                                    <a href="{{ route('proyek.index', array_merge(request()->query(), ['sort_by' => 'target_selesai', 'order' => $newOrder])) }}" 
                                       class="flex items-center hover:text-blue-700 {{ $sortBy == 'target_selesai' ? 'text-blue-600 font-bold' : '' }}">
                                        Sisa Waktu
                                        <span class="ml-1.5">@if ($sortBy == 'target_selesai') {!! $order == 'asc' ? '↑' : '↓' !!} @else <span class="text-gray-300">↕</span> @endif</span>
                                    </a>
                                </th>
                                <th class="py-3 px-4 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">
                                     @php $newOrder = ($sortBy == 'pic' && $order == 'asc') ? 'desc' : 'asc'; @endphp
                                    <a href="{{ route('proyek.index', array_merge(request()->query(), ['sort_by' => 'pic', 'order' => $newOrder])) }}" 
                                       class="flex items-center hover:text-blue-700 {{ $sortBy == 'pic' ? 'text-blue-600 font-bold' : '' }}">
                                        PIC
                                        <span class="ml-1.5">@if ($sortBy == 'pic') {!! $order == 'asc' ? '↑' : '↓' !!} @else <span class="text-gray-300">↕</span> @endif</span>
                                    </a>
                                </th>
                                <th class="py-3 px-4 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">
                                     @php $newOrder = ($sortBy == 'status' && $order == 'asc') ? 'desc' : 'asc'; @endphp
                                    <a href="{{ route('proyek.index', array_merge(request()->query(), ['sort_by' => 'status', 'order' => $newOrder])) }}" 
                                       class="flex items-center hover:text-blue-700 {{ $sortBy == 'status' ? 'text-blue-600 font-bold' : '' }}">
                                        Status
                                        <span class="ml-1.5">@if ($sortBy == 'status') {!! $order == 'asc' ? '↑' : '↓' !!} @else <span class="text-gray-300">↕</span> @endif</span>
                                    </a>
                                </th>
                                <th class="py-3 px-4 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">Aksi</th>
                            </tr>
                        </thead>

                        <tbody class="divide-y divide-gray-200">
                            @forelse ($proyeks as $proyek)
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="py-3 px-4 font-medium text-gray-800 whitespace-nowrap">{{ $proyek->nama_proyek }}</td>
                                <td class="py-3 px-4 text-gray-600 whitespace-nowrap">Rp. {{ number_format($proyek->nilai_kontrak, 0, ',', '.') }}</td>
                                <td class="py-3 px-4 text-red-600 font-semibold whitespace-nowrap">
                                    Rp. {{ number_format($proyek->total_pengeluaran ?? 0, 0, ',', '.') }}
                                </td>
                                @php
                                    $sisaAnggaran = $proyek->nilai_kontrak - ($proyek->total_pengeluaran ?? 0);
                                @endphp
                                <td class="py-3 px-4 font-semibold whitespace-nowrap {{ $sisaAnggaran < 0 ? 'text-red-600' : 'text-green-600' }}">
                                    Rp. {{ number_format($sisaAnggaran, 0, ',', '.') }}
                                </td>
                                <td class="py-3 px-4 text-gray-600 font-semibold whitespace-nowrap">{{ $proyek->sisa_waktu }}</td>
                                <td class="py-3 px-4 text-gray-600 whitespace-nowrap">{{ $proyek->pic }} ({{ $proyek->no_pic }})</td>
                                <td class="py-3 px-4 whitespace-nowrap">
                                    <span class="px-2.5 py-0.5 rounded-full text-xs font-semibold
                                        @if($proyek->status == 'Selesai') bg-green-100 text-green-800
                                        @elseif($proyek->status == 'Ditunda') bg-red-100 text-red-800
                                        @else bg-yellow-100 text-yellow-800 @endif">
                                        {{ $proyek->status }}
                                    </span>
                                </td>
                                
                                <td class="py-3 px-4 flex items-center space-x-2 whitespace-nowrap">
                                    <a href="{{ route('proyek.show', $proyek->id_proyek) }}" class="bg-blue-500 hover:bg-blue-600 text-white font-bold py-1.5 px-3 rounded text-xs transition-colors">View</a>
                                    
                                    @if($proyek->status !== 'Selesai')
                                        <form action="{{ route('proyek.tandaiSelesai', $proyek->id_proyek) }}" method="POST" onsubmit="return confirm('Anda yakin menandai proyek ini sebagai Selesai?');">
                                            @csrf
                                            <button type="submit" class="bg-green-500 hover:bg-green-600 text-white font-bold py-1.5 px-3 rounded text-xs transition-colors">Selesai</button>
                                        </form>
                                    @else
                                        <span class="font-bold py-1.5 px-3 rounded text-xs invisible">Selesai</span>
                                    @endif
                                    
                                    <a href="{{ route('proyek.edit', $proyek->id_proyek) }}" class="bg-yellow-500 hover:bg-yellow-600 text-white font-bold py-1.5 px-3 rounded text-xs transition-colors">Edit</a>
                                    
                                    <button type="button" 
                                        @click="
                                            deleteModalAction = '{{ route('proyek.destroy', $proyek->id_proyek) }}';
                                            deleteModalTitle = 'Arsipkan Proyek?';
                                            deleteModalMessage = 'Anda yakin ingin mengarsipkan proyek <strong>{{ e($proyek->nama_proyek) }}</strong>? <br><br>Proyek akan disembunyikan dari daftar, namun data pengeluarannya tetap aman.';
                                            showDeleteModal = true;
                                        "
                                        class="bg-red-500 hover:bg-red-600 text-white font-bold py-1.5 px-3 rounded text-xs transition-colors">
                                        Arsip
                                    </button>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="9" class="text-center py-10 text-gray-500">
                                    <div class="flex flex-col items-center justify-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-12 w-12 text-gray-300 mb-2" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5"></path></svg>
                                        <p>Tidak ada data proyek yang ditemukan.</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse 
                            
                        </tbody>
                    </table>
                </div>
                
                {{-- Pagination --}}
                <div class="p-4 bg-gray-50 border-t border-gray-100">
                    {{ $proyeks->links() }}
                </div>
            </div>
        </div> {{-- Penutup List View --}}

        {{-- Pagination untuk Grid View --}}
        <div x-show="viewMode === 'grid'" class="mt-6" style="display: none;">
            {{ $proyeks->links() }}
        </div>

    </div> {{-- Penutup 'space-y-8' --}}


    {{-- ========================================================= --}}
    {{-- MODAL KONFIRMASI HAPUS (Tidak Berubah)                    --}}
    {{-- ========================================================= --}}
    <div x-show="showDeleteModal" 
         @keydown.escape.window="showDeleteModal = false"
         class="fixed inset-0 bg-black bg-opacity-70 flex items-center justify-center p-4 z-[9999]" 
         style="display: none;">
        
        <form :action="deleteModalAction" method="POST"
              @click.stop class="bg-white rounded-xl shadow-2xl w-full max-w-md transform transition-all"
              x-show="showDeleteModal"
              x-transition:enter="ease-out duration-300"
              x-transition:enter-start="opacity-0 scale-90"
              x-transition:enter-end="opacity-100 scale-100"
              x-transition:leave="ease-in duration-200"
              x-transition:leave-start="opacity-100 scale-100"
              x-transition:leave-end="opacity-0 scale-90">
            
            @csrf
            @method('DELETE')

            <div class="p-6">
                <div class="flex">
                    <div class="flex-shrink-0 flex items-center justify-center h-12 w-12 rounded-full bg-red-100 sm:mx-0 sm:h-10 sm:w-10">
                        <svg class="h-6 w-6 text-red-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
                        </svg>
                    </div>
                    
                    <div class="ml-4 text-left">
                        <h3 class="text-lg leading-6 font-bold text-gray-900" x-text="deleteModalTitle || 'Konfirmasi Hapus'">
                            Konfirmasi Hapus
                        </h3>
                        <div class="mt-2">
                            <p class="text-sm text-gray-600" x-html="deleteModalMessage">
                                Anda yakin ingin menghapus data ini?
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="bg-gray-50 px-6 py-4 flex justify-end space-x-3 rounded-b-xl">
                <button type="button" 
                        @click="showDeleteModal = false" 
                        class="px-4 py-2 bg-white text-gray-700 font-semibold rounded-lg border border-gray-300 hover:bg-gray-50 transition-colors">
                    Batal
                </button>
                <button type="submit" 
                        class="px-4 py-2 bg-red-600 text-white font-semibold rounded-lg hover:bg-red-700 transition-colors">
                    Ya, Arsipkan
                </button>
            </div>
        </form>
    </div>
    
</div> {{-- Penutup 'x-data' --}}
@endsection