@extends('layouts.app')

@section('content')
<div class="space-y-6">
    {{-- Header Halaman --}}
    <div>
        <h1 class="text-3xl font-bold text-gray-800">Edit Data Pembayaran</h1>
        <p class="text-gray-500 mt-1">Perbarui detail pembayaran untuk mandor <strong>{{ $tukang->nama_mandor }}</strong>.</p>
    </div>

    {{-- Form Edit --}}
    <div class="bg-white p-6 rounded-xl shadow-lg border border-gray-200">
        {{-- PENTING: Tambahkan enctype untuk file upload --}}
        <form action="{{ route('tukang.update', $tukang->id_tukang) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="space-y-8">
                
                {{-- Bagian 1: Informasi Utama --}}
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold text-gray-800 border-b border-gray-200 pb-2">Informasi Utama</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="id_proyek" class="block text-sm font-medium text-gray-700 mb-1">Pilih Proyek <span class="text-red-500">*</span></label>
                            <select id="id_proyek" name="id_proyek" class="w-full border-gray-300 rounded-lg shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                                @foreach ($proyeks as $proyek)
                                    <option value="{{ $proyek->id_proyek }}" {{ $tukang->id_proyek == $proyek->id_proyek ? 'selected' : '' }}>
                                        {{ $proyek->nama_proyek }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        
                        {{-- [MODIFIKASI] Input Nama Mandor --}}
                        <div>
                            <label for="nama_mandor" class="block text-sm font-medium text-gray-700 mb-1">Nama Mandor <span class="text-red-500">*</span></label>
                            <select id="nama_mandor" name="nama_mandor" class="w-full border-gray-300 rounded-lg shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                                @foreach ($mandors as $mandor)
                                    <option value="{{ $mandor->nama_mandor }}" {{ $tukang->nama_mandor == $mandor->nama_mandor ? 'selected' : '' }}>
                                        {{ $mandor->nama_mandor }}
                                    </option>
                                @endforeach
                                <option value="TAMBAH_BARU_MANDOR_#">-- Tambah Mandor Baru --</option>
                            </select>

                            {{-- [TAMBAHAN] Input untuk mandor baru (tersembunyi) --}}
                            <input type="text" id="nama_mandor_baru" name="nama_mandor_baru" 
                                   class="w-full border-gray-300 rounded-lg shadow-sm focus:border-blue-500 focus:ring-blue-500 mt-2 hidden" 
                                   placeholder="Masukkan nama mandor baru">
                            @error('nama_mandor_baru')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Bagian 2: Detail Pembayaran --}}
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold text-gray-800 border-b border-gray-200 pb-2">Detail Pembayaran</h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div>
                            <label for="total_pembayaran" class="block text-sm font-medium text-gray-700 mb-1">Total Pembayaran <span class="text-red-500">*</span></label>
                            <div class="relative mt-1 rounded-lg shadow-sm">
                                <div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-3">
                                    <span class="text-gray-500 sm:text-sm">Rp</span>
                                </div>
                                <input type="number" id="total_pembayaran" name="total_pembayaran" value="{{ $tukang->total_pembayaran }}" class="w-full border-gray-300 rounded-lg shadow-sm pl-8 focus:border-blue-500 focus:ring-blue-500" required>
                            </div>
                        </div>
                        <div>
                            <label for="tanggal_jatuh_tempo" class="block text-sm font-medium text-gray-700 mb-1">Tgl. Jatuh Tempo <span class="text-red-500">*</span></label>
                            <input type="date" id="tanggal_jatuh_tempo" name="tanggal_jatuh_tempo" value="{{ $tukang->tanggal_jatuh_tempo }}" class="w-full border-gray-300 rounded-lg shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                        </div>
                        <div>
                            <label for="tanggal_pembayaran" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Pembayaran</label>
                            <input type="date" id="tanggal_pembayaran" name="tanggal_pembayaran" value="{{ $tukang->tanggal_pembayaran }}" class="w-full border-gray-300 rounded-lg shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        </div>
                    </div>
                    <div class="pt-4">
                         <label for="status_pembayaran" class="block text-sm font-medium text-gray-700 mb-1">Status Pembayaran <span class="text-red-500">*</span></label>
                        <select id="status_pembayaran" name="status_pembayaran" class="w-full md:w-1/3 border-gray-300 rounded-lg shadow-sm focus:border-blue-500 focus:ring-blue-500" required>
                            <option value="Belum Lunas" {{ $tukang->status_pembayaran == 'Belum Lunas' ? 'selected' : '' }}>Belum Lunas</option>
                            <option value="Lunas" {{ $tukang->status_pembayaran == 'Lunas' ? 'selected' : '' }}>Lunas</option>
                        </select>
                    </div>
                </div>

                {{-- Bagian 3: Lampiran --}}
                <div class="space-y-4">
                    <h3 class="text-lg font-semibold text-gray-800 border-b border-gray-200 pb-2">Lampiran (Opsional)</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        {{-- Input File Kustom untuk Bukti Absensi --}}
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Ganti Bukti Absensi</label>
                            <label for="bukti_absensi" class="relative cursor-pointer bg-white border border-gray-300 rounded-lg shadow-sm px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50 flex items-center">
                                <svg class="w-5 h-5 mr-2 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                  <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75V16.5m-13.5-9L12 3m0 0l4.5 4.5M12 3v13.5" />
                                </svg>
                                <span id="file-name-absensi" class="truncate">Pilih file baru... (Max 2MB)</span>
                            </label>
                            <input type="file" id="bukti_absensi" name="bukti_absensi" class="hidden" onchange="updateFileName('bukti_absensi', 'file-name-absensi')">
                            @if ($tukang->bukti_absensi)
                                <div class="mt-2 text-xs text-gray-600 flex items-center">
                                    <svg class="w-4 h-4 mr-1 text-green-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    File saat ini: 
                                    <a href="{{ asset('storage/' . $tukang->bukti_absensi) }}" target="_blank" class="ml-1 text-blue-600 hover:underline truncate" title="{{ basename($tukang->bukti_absensi) }}">
                                        {{ \Illuminate\Support\Str::limit(basename($tukang->bukti_absensi), 25) }}
                                    </a>
                                </div>
                            @endif
                        </div>
                        
                        {{-- Input File Kustom untuk Bukti Pembayaran --}}
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Ganti Bukti Pembayaran</label>
                            <label for="bukti_pembayaran" class="relative cursor-pointer bg-white border border-gray-300 rounded-lg shadow-sm px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50 flex items-center">
                                <svg class="w-5 h-5 mr-2 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                  <path stroke-linecap="round" stroke-linejoin="round" d="M3 16.5v2.25A2.25 2.25 0 005.25 21h13.5A2.25 2.25 0 0021 18.75V16.5m-13.5-9L12 3m0 0l4.5 4.5M12 3v13.5" />
                                </svg>
                                <span id="file-name-pembayaran" class="truncate">Pilih file baru... (Max 2MB)</span>
                            </label>
                            <input type="file" id="bukti_pembayaran" name="bukti_pembayaran" class="hidden" onchange="updateFileName('bukti_pembayaran', 'file-name-pembayaran')">
                            @if ($tukang->bukti_pembayaran)
                                <div class="mt-2 text-xs text-gray-600 flex items-center">
                                    <svg class="w-4 h-4 mr-1 text-green-500" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                                      <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                    </svg>
                                    File saat ini: 
                                    <a href="{{ asset('storage/' . $tukang->bukti_pembayaran) }}" target="_blank" class="ml-1 text-blue-600 hover:underline truncate" title="{{ basename($tukang->bukti_pembayaran) }}">
                                        {{ \Illuminate\Support\Str::limit(basename($tukang->bukti_pembayaran), 25) }}
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

            </div>

            {{-- Tombol Aksi --}}
            <div class="mt-8 flex justify-end space-x-4 border-t border-gray-200 pt-6">
                <a href="{{ route('tukang.index') }}" class="px-4 py-2 bg-gray-200 text-gray-800 font-bold rounded-lg hover:bg-gray-300 transition duration-150">
                    Batal
                </a>
                <button type="submit" class="px-4 py-2 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition duration-150">
                    Update Data
                </button>
            </div>
        </form>
    </div>
</div>

{{-- Script untuk menampilkan nama file --}}
@push('scripts')
<script>
    function updateFileName(inputId, spanId) {
        const input = document.getElementById(inputId);
        const span = document.getElementById(spanId);
        if (input.files && input.files.length > 0) {
            span.textContent = input.files[0].name;
        } else {
            // Teks default sedikit berbeda untuk edit
            span.textContent = 'Pilih file baru... (Max 2MB)';
        }
    }

    // [TAMBAHAN] Script untuk show/hide input mandor baru
    document.getElementById('nama_mandor').addEventListener('change', function() {
        const inputMandorBaru = document.getElementById('nama_mandor_baru');
        if (this.value === 'TAMBAH_BARU_MANDOR_#') {
            inputMandorBaru.classList.remove('hidden');
            inputMandorBaru.required = true;
        } else {
            inputMandorBaru.classList.add('hidden');
            inputMandorBaru.required = false;
            inputMandorBaru.value = ''; // Kosongkan nilainya
        }
    });
</script>
@endpush
@endsection