
<?php $__env->startSection('content'); ?>


<div class=""
     x-data="{
        viewMode: localStorage.getItem('klienViewMode') || 'grid',
        setView(mode) {
            this.viewMode = mode;
            localStorage.setItem('klienViewMode', mode);
        },

        /* State untuk modal hapus kustom */
        deleteModalOpen: false,
        deleteModalItemName: '',
        deleteModalItemInfo: '',
        deleteFormUrl: '',
     }">

    
    <div class="flex flex-col md:flex-row justify-between items-center mb-8 gap-4">
        <div>
            <h1 class="text-3xl font-bold text-gray-800">Data legalitas</h1>
            <p class="text-gray-500 text-sm mt-1">Kelola data legalitas dan dokumen proyek.</p>
        </div>

        <div class="flex flex-col sm:flex-row gap-3 items-center w-full md:w-auto">
            
            <a href="<?php echo e(route('klien.create')); ?>" class="bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 px-4 rounded-lg flex items-center transition duration-150 ease-in-out w-full sm:w-auto justify-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                    <path fill-rule="evenodd" d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z" clip-rule="evenodd" />
                </svg>
                Tambah Data Klien
            </a>

            
            <div class="bg-gray-100 p-1 rounded-lg flex items-center border border-gray-200">
                <button @click="setView('grid')"
                        :class="viewMode === 'grid' ? 'bg-white text-blue-600 shadow-sm' : 'text-gray-500 hover:text-gray-700'"
                        class="p-2 rounded-md transition duration-150 ease-in-out flex items-center justify-center"
                        title="Tampilan Grid">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z" />
                    </svg>
                </button>
                <button @click="setView('list')"
                        :class="viewMode === 'list' ? 'bg-white text-blue-600 shadow-sm' : 'text-gray-500 hover:text-gray-700'"
                        class="p-2 rounded-md transition duration-150 ease-in-out flex items-center justify-center"
                        title="Tampilan List">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-4 mb-6">
        <form action="<?php echo e(route('klien.index')); ?>" method="GET">
            <div class="flex flex-col md:flex-row gap-3">
                <div class="flex-1 relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <svg class="h-5 w-5 text-gray-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd" /></svg>
                    </div>
                    <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Cari proyek, klien, atau alamat..." class="pl-10 block w-full rounded-lg border-gray-300 shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm h-11">
                </div>
                <div class="w-full md:w-48">
                    <select name="status" class="block w-full rounded-lg border-gray-300 shadow-sm focus:ring-blue-500 focus:border-blue-500 sm:text-sm h-11 cursor-pointer">
                        <option value="">- Semua Status -</option>
                        <option value="Proses" <?php echo e(request('status') == 'Proses' ? 'selected' : ''); ?>>Proses</option>
                        <option value="Belum Lengkap" <?php echo e(request('status') == 'Belum Lengkap' ? 'selected' : ''); ?>>Belum Lengkap</option>
                        <option value="Lengkap" <?php echo e(request('status') == 'Lengkap' ? 'selected' : ''); ?>>Lengkap</option>
                    </select>
                </div>
                <div>
                    <button type="submit" class="w-full md:w-auto bg-gray-800 hover:bg-gray-900 text-white font-medium px-6 rounded-lg transition duration-150 ease-in-out h-11 flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M3 3a1 1 0 011-1h12a1 1 0 011 1v3a1 1 0 01-.293.707L12 11.414V15a1 1 0 01-.293.707l-2 2A1 1 0 018 17v-5.586L3.293 6.707A1 1 0 013 6V3z" clip-rule="evenodd" /></svg>
                        Filter
                    </button>
                </div>
                <?php if(request()->hasAny(['search', 'status'])): ?>
                <div>
                    <a href="<?php echo e(route('klien.index')); ?>" class="w-full md:w-auto bg-gray-100 hover:bg-gray-200 text-gray-600 font-medium px-4 rounded-lg transition duration-150 ease-in-out h-11 flex items-center justify-center" title="Reset Filter">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" /></svg>
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </form>
    </div>

    
    <?php if(session('success')): ?>
        <div class="mb-6 bg-green-50 border-l-4 border-green-500 p-4 rounded-md">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4 rounded-md">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    
    <div>
        
        <div x-show="viewMode === 'grid'"
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 transform scale-95"
             x-transition:enter-end="opacity-100 transform scale-100"
             class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6"> 

            <?php $__empty_1 = true; $__currentLoopData = $dataKliens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $klien): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="bg-white rounded-xl shadow-sm hover:shadow-md transition-shadow duration-300 border border-gray-100 overflow-hidden flex flex-col">
                    <div class="p-6 flex-1">
                        <div class="flex justify-between items-start mb-4">
                            <h3 class="text-lg font-bold text-gray-900 line-clamp-2" title="<?php echo e($klien->proyek->nama_proyek ?? 'Proyek Dihapus'); ?>">
                                <?php echo e($klien->proyek->nama_proyek ?? '-'); ?>

                            </h3>
                            <?php
                                $statusColors = [
                                    'Lengkap' => 'bg-green-100 text-green-800',
                                    'Proses' => 'bg-yellow-100 text-yellow-800',
                                    'Belum Lengkap' => 'bg-red-100 text-red-800',
                                ];
                                $statusClass = $statusColors[$klien->status] ?? 'bg-gray-100 text-gray-800';
                            ?>
                            <span class="px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($statusClass); ?> whitespace-nowrap ml-2">
                                <?php echo e($klien->status); ?>

                            </span>
                        </div>
                        <div class="space-y-3">
                            <div>
                                <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Klien</p>
                                <p class="text-sm font-semibold text-gray-900"><?php echo e($klien->user->name ?? '-'); ?></p>
                            </div>
                            <div>
                                <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Alamat</p>
                                <p class="text-sm text-gray-700 line-clamp-2" title="<?php echo e($klien->alamat); ?>"><?php echo e($klien->alamat); ?></p>
                            </div>
                            <div>
                                <p class="text-xs font-medium text-gray-500 uppercase tracking-wider">Jenis Bangunan</p>
                                <p class="text-sm text-gray-700"><?php echo e($klien->jenis_bangunan); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 px-6 py-4 border-t border-gray-100 flex items-center justify-between">
                        <a href="<?php echo e(route('klien.show', $klien->id)); ?>" class="flex-1 bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium py-2 px-4 rounded-lg text-center transition-colors duration-150 mr-3 flex items-center justify-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-1.5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" /></svg>
                            Detail
                        </a>
                        <div class="flex space-x-2">
                            <a href="<?php echo e(route('klien.edit', $klien->id)); ?>" class="text-gray-400 hover:text-blue-600 transition-colors duration-150 p-2 hover:bg-blue-50 rounded-full" title="Edit">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" /></svg>
                            </a>
                            <button type="button" 
                                    @click.prevent="
                                        deleteModalOpen = true;
                                        deleteModalItemName = '<?php echo e(addslashes($klien->proyek->nama_proyek ?? '-')); ?>';
                                        deleteModalItemInfo = 'Klien: <?php echo e(addslashes($klien->user->name ?? '-')); ?>';
                                        deleteFormUrl = '<?php echo e(route('klien.destroy', $klien->id)); ?>';
                                    "
                                    class="text-gray-400 hover:text-red-600 transition-colors duration-150 p-2 hover:bg-red-50 rounded-full" 
                                    title="Hapus">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" /></svg>
                            </button>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-span-full flex flex-col items-center justify-center p-12 bg-white rounded-xl border border-dashed border-gray-300 text-gray-500">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-16 w-16 text-gray-300 mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" /></svg>
                    <h3 class="text-lg font-medium text-gray-900">Belum ada data klien</h3>
                    <p class="mt-1 text-sm">Mulailah dengan menambahkan data klien baru.</p>
                </div>
            <?php endif; ?>
        </div>

        
        <div x-show="viewMode === 'list'" 
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 transform scale-95"
             x-transition:enter-end="opacity-100 transform scale-100"
             style="display: none;"
             class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            
            
            <table class="w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Nama Proyek
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Klien
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Alamat
                        </th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Jenis
                        </th>
                        
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">
                            Status
                        </th>
                        
                        <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider whitespace-nowrap">
                            Aksi
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $dataKliens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $klien): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50 transition-colors duration-150">
                            
                            <td class="px-6 py-4 text-sm font-medium text-gray-900 break-words" title="<?php echo e($klien->proyek->nama_proyek ?? '-'); ?>">
                                <?php echo e($klien->proyek->nama_proyek ?? '-'); ?>

                            </td>
                            <td class="px-6 py-4 text-sm text-gray-700 break-words" title="<?php echo e($klien->user->name ?? '-'); ?>">
                                <?php echo e($klien->user->name ?? '-'); ?>

                            </td>
                            <td class="px-6 py-4 text-sm text-gray-700 break-words" title="<?php echo e($klien->alamat); ?>">
                                <?php echo e($klien->alamat); ?>

                            </td>
                            <td class="px-6 py-4 text-sm text-gray-700 break-words">
                                <?php echo e($klien->jenis_bangunan); ?>

                            </td>
                            
                            
                            <td class="px-6 py-4 whitespace-nowrap">
                                <?php
                                    $statusColors = [
                                        'Lengkap' => 'bg-green-100 text-green-800',
                                        'Proses' => 'bg-yellow-100 text-yellow-800',
                                        'Belum Lengkap' => 'bg-red-100 text-red-800',
                                    ];
                                    $statusClass = $statusColors[$klien->status] ?? 'bg-gray-100 text-gray-800';
                                ?>
                                <span class="px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($statusClass); ?>">
                                    <?php echo e($klien->status); ?>

                                </span>
                            </td>

                            
                            <td class="px-6 py-4 text-right text-sm font-medium whitespace-nowrap">
                                <div class="flex items-center justify-end space-x-2">
                                    <a href="<?php echo e(route('klien.show', $klien->id)); ?>" class="text-gray-400 hover:text-blue-600 transition-colors duration-150 p-2 hover:bg-blue-50 rounded-full" title="Detail">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" /><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" /></svg>
                                    </a>
                                    <a href="<?php echo e(route('klien.edit', $klien->id)); ?>" class="text-gray-400 hover:text-blue-600 transition-colors duration-150 p-2 hover:bg-blue-50 rounded-full" title="Edit">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" /></svg>
                                    </a>
                                    <button type="button" 
                                            @click.prevent="
                                                deleteModalOpen = true;
                                                deleteModalItemName = '<?php echo e(addslashes($klien->proyek->nama_proyek ?? '-')); ?>';
                                                deleteModalItemInfo = 'Klien: <?php echo e(addslashes($klien->user->name ?? '-')); ?>';
                                                deleteFormUrl = '<?php echo e(route('klien.destroy', $klien->id)); ?>';
                                            "
                                            class="text-gray-400 hover:text-red-600 transition-colors duration-150 p-2 hover:bg-red-50 rounded-full" 
                                            title="Hapus">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" /></svg>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center">
                                <div class="flex flex-col items-center justify-center text-gray-500">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-16 w-16 text-gray-300 mb-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" /></svg>
                                    <h3 class="text-lg font-medium text-gray-900">Belum ada data klien</h3>
                                    <p class="mt-1 text-sm">Mulailah dengan menambahkan data klien baru.</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    


    
    
    
    <div x-show="deleteModalOpen" style="display: none;" class="fixed inset-0 z-50 flex items-center justify-center p-4" @keydown.escape.window="deleteModalOpen = false">
        <div class="fixed inset-0 bg-black bg-opacity-50" @click="deleteModalOpen = false"></div>
        <div x-show="deleteModalOpen" x-transition 
             class="relative bg-white rounded-lg shadow-xl w-full max-w-md p-6">
            
            <h3 class="text-xl font-bold text-gray-900 mb-4">Konfirmasi Hapus</h3>
            <p class="text-gray-600 mb-2">
                Anda yakin ingin menghapus data klien ini?
            </p>
            <p class="mb-4">
                Proyek: <strong x-text="deleteModalItemName"></strong><br>
                Klien: <strong x-text="deleteModalItemInfo"></strong>
            </p>
            <p class="text-sm text-red-600 bg-red-50 p-3 rounded-lg">
                Tindakan ini tidak dapat dibatalkan. Semua file terkait juga akan dihapus (jika ada).
            </p>

            <form :action="deleteFormUrl" method="POST" class="mt-6">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <div class="flex justify-end gap-4">
                    <button type="button" @click="deleteModalOpen = false" class="w-full sm:w-auto py-2 px-4 bg-white border border-gray-300 rounded-lg text-gray-700 font-semibold hover:bg-gray-50 transition-colors">
                        Batal
                    </button>
                    <button type="submit" class="w-full sm:w-auto py-2 px-4 bg-red-600 border border-red-600 rounded-lg text-white font-semibold hover:bg-red-700 transition-colors">
                        Ya, Hapus
                    </button>
                </div>
            </form>
        </div>
    </div>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.project', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\kontraktor-dashboard\resources\views/klien/index.blade.php ENDPATH**/ ?>