<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?> - Manajemen Proyek</title>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" />

    <style>
        body { font-family: 'Inter', sans-serif; }
        .transition-all-300 {
            transition: all 300ms ease-in-out;
        }
        [x-cloak] { display: none !important; }
    </style>
    
    <?php echo $__env->yieldContent('styles'); ?>
    <?php echo $__env->yieldPushContent('styles'); ?> 
</head>
<body class="font-sans antialiased bg-gray-100">
    <div x-data="{ sidebarOpen: window.innerWidth > 1024 }" class="flex min-h-screen">
        
        <aside
            class="bg-white text-gray-800 w-64 fixed inset-y-0 left-0 z-30 transform transition-all-300 border-r border-gray-200"
            :class="{'translate-x-0': sidebarOpen, '-translate-x-full': !sidebarOpen}">
            
            <div class="flex flex-col h-full">
                
                <div>
                    <div class="p-6 flex items-center space-x-3">
                        <span class="text-blue-600">
                            <i class="fas fa-cogs fa-2x"></i>
                        </span>
                        <a href="#" class="text-xl font-bold truncate">Manajemen Proyek</a>
                    </div>
                </div>
                
                <div class="flex-1 overflow-y-auto">
                    
                    
                    
                    
                    <nav class="mt-4">
                        <ul>
                            <li class="px-6 py-2 text-xs font-semibold text-gray-500 uppercase tracking-wider">
                                Manajemen Internal
                            </li>

                            <li class="px-4 py-1">
                                <a href="<?php echo e(route('tasks.index')); ?>" 
                                   class="flex items-center px-4 py-2 rounded-lg transition-transform duration-200 ease-out hover:scale-95 active:scale-90 <?php echo e(request()->routeIs('tasks.*') ? 'bg-blue-600 text-white' : 'text-gray-800'); ?>">
                                    <i class="fas fa-tasks w-5 h-5 mr-3 text-center"></i>
                                    <span>Manajemen Tugas</span>
                                </a>
                            </li>
                            
                            <?php if(Auth::user()->role == 'admin'): ?>
                                <li class="px-4 py-1">
                                    <a href="<?php echo e(route('anggota.index')); ?>" 
                                       class="flex items-center px-4 py-2 rounded-lg transition-transform duration-200 ease-out hover:scale-95 active:scale-90 <?php echo e(request()->routeIs('anggota.*') ? 'bg-blue-600 text-white' : 'text-gray-800'); ?>">
                                        <i class="fas fa-user-friends w-5 h-5 mr-3 text-center"></i>
                                        <span>Tambah Anggota</span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php if(Auth::user()->role == 'admin'): ?>
                                <li class="px-4 py-1">
                                    <a href="<?php echo e(route('teams.index')); ?>" 
                                       class="flex items-center px-4 py-2 rounded-lg transition-transform duration-200 ease-out hover:scale-95 active:scale-90 <?php echo e(request()->routeIs('teams.*') ? 'bg-blue-600 text-white' : 'text-gray-800'); ?>">
                                        <i class="fas fa-users-cog w-5 h-5 mr-3 text-center"></i>
                                        <span>Manajemen Tim</span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <li class="px-6 py-2 mt-4 text-xs font-semibold text-gray-500 uppercase tracking-wider">
                                Manajemen Klien
                            </li>

                            <?php if(Auth::user()->role == 'admin'): ?>
                                <li class="px-4 py-1">
                                    <a href="<?php echo e(route('klien.index')); ?>" 
                                       class="flex items-center px-4 py-2 rounded-lg transition-transform duration-200 ease-out hover:scale-95 active:scale-90 <?php echo e(request()->routeIs('klien.*') ? 'bg-blue-600 text-white' : 'text-gray-800'); ?>">
                                        <i class="fas fa-file-alt w-5 h-5 mr-3 text-center"></i>
                                        <span>Legalitas & Klien</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                            <li class="px-4 py-1">
                                <a href="<?php echo e(route('progress.index')); ?>" 
                                   class="flex items-center px-4 py-2 rounded-lg ... <?php echo e(request()->routeIs('progress.*') ? 'bg-blue-600 text-white' : 'text-gray-800'); ?>">
                                    <i class="fas fa-clipboard-check w-5 h-5 mr-3 text-center"></i>
                                    <span>Progress Legalitas</span>
                                </a>
                            </li>
                            <li class="px-4 pt-4">
                                <div class="border-t border-gray-200"></div>
                            </li>
                        </ul>
                    </nav>
                </div>
                
                <div class="mt-auto p-6">
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="w-full bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded-lg transition-all duration-200 ease-out hover:scale-95 active:scale-90 flex items-center justify-center">
                            <i class="fas fa-sign-out-alt w-5 h-5 mr-2"></i>
                            <span>Logout</span>
                        </button>
                    </form>
                </div>
            </div>
        </aside>

        <div x-show="sidebarOpen"
             @click="sidebarOpen = false"
             x-transition:enter="transition-opacity ease-linear duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition-opacity ease-linear duration-300"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             class="fixed inset-0 bg-black bg-opacity-50 z-20 lg:hidden"
             x-cloak>
        </div>

        <div class="flex-1 flex flex-col transition-all-300" :class="{'lg:ml-64': sidebarOpen}">
            
            <header class="bg-white shadow-md p-4 flex justify-between items-center sticky top-0 z-10">
                <button @click="sidebarOpen = !sidebarOpen" class="text-gray-500 focus:outline-none focus:text-gray-700">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path></svg>
                </button>

                <div class="text-lg font-semibold text-gray-800 hidden sm:block">
                    <?php echo $__env->yieldContent('header'); ?>
                </div>

                <div class="flex items-center">
                    <?php if(auth()->guard()->check()): ?>
                        <span class="text-gray-800 mr-4 hidden sm:block">Selamat datang, <span class="font-bold"><?php echo e(Auth::user()->name); ?></span></span>
                        <div class="w-10 h-10 bg-blue-600 rounded-full flex items-center justify-center text-white font-bold">
                            <?php echo e(substr(Auth::user()->name, 0, 1)); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </header>

            
            <main class="flex-1 <?php echo $__env->yieldContent('main-padding', 'p-6 md:p-8'); ?> overflow-y-auto">
                <div class="text-lg font-semibold text-gray-800 sm:hidden mb-4">
                    <?php echo $__env->yieldContent('header'); ?>
                </div>
                <?php echo $__env->yieldContent('content'); ?>
            </main>
        </div>
    </div>

    <?php echo $__env->yieldContent('scripts'); ?>
    <?php echo $__env->yieldPushContent('scripts'); ?> 
</body>
</html><?php /**PATH C:\xampp\htdocs\kontraktor-dashboard\resources\views/layouts/project.blade.php ENDPATH**/ ?>